#ifndef IPOD_PLAYER_DEF_IN_H
#define IPOD_PLAYER_DEF_IN_H

#define IPOD_PLAYER_ENGINE_TYPE_GASOLINE    "Gasoline"
#define IPOD_PLAYER_ENGINE_TYPE_DIESEL      "Diesel"
#define IPOD_PLAYER_ENGINE_TYPE_ELECTRIC    "Electric"
#define IPOD_PLAYER_ENGINE_TYPE_CNG         "CNG"

#define IPOD_PLAYER_VSTATUS_TYPE_RANGE          "Range"
#define IPOD_PLAYER_VSTATUS_TYPE_OUTSIDETEMP    "OutsideTemperature"
#define IPOD_PLAYER_VSTATUS_TYPE_RANGE_WARNING  "RangeWarning"

#define IPOD_PLAYER_NOTIFY_FUNC_MASK        0x02000000UL
#define IPOD_PLAYER_INTERNAL_FUNC_MASK      0x04000000UL
#define IPOD_PLAYER_RESULT_ID_MASK          0x08000000UL
#define IPOD_PLAYER_FUNCTION_MASK           0x00FFFFFFUL

#define IPOD_PLAYER_INIT_GROUP_MASK         0x00010000UL
#define IPOD_PLAYER_PLAYBACK_GROUP_MASK     0x00020000UL
#define IPOD_PLAYER_DATABASE_GROUP_MASK     0x00040000UL
#define IPOD_PLAYER_NONPLAYER_GROUP_MASK    0x00080000UL
#define IPOD_PLAYER_INTERNAL_GROUP_MASK     0x00100000UL
#define IPOD_PLAYER_CANCEL_GROUP_MASK       0x00200000UL
#define IPOD_PLAYER_NOTIFY_GROUP_MASK       0x00400000UL
#define IPOD_PLAYER_STATUS_GROUP_MASK       0x00800000UL
#define IPOD_PLAYER_AUDIO_GROUP_MASK        0x01000000UL

#define IPOD_PLAYER_INTERNAL_GET_STATUS_MASK    0x02000000UL
#define IPOD_PLAYER_COVERART_MASK               0x04000000UL
#define IPOD_PLAYER_INTERNAL_HMI_BUTTON_MASK    0x08000000UL
#define IPOD_PLAYER_INTERNAL_HMI_STATUS_MASK    0x10000000UL

#define IPOD_PLAYER_COVERART_GROUP_MASK     (IPOD_PLAYER_PLAYBACK_GROUP_MASK | \
                                             IPOD_PLAYER_DATABASE_GROUP_MASK | \
                                             IPOD_PLAYER_NONPLAYER_GROUP_MASK | \
                                             IPOD_PLAYER_INTERNAL_GET_STATUS_MASK | \
                                             IPOD_PLAYER_NOTIFY_GROUP_MASK | \
                                             IPOD_PLAYER_CANCEL_GROUP_MASK | \
                                             IPOD_PLAYER_COVERART_MASK)

#define IPOD_PLAYER_ACCINFO_NULL    -1

/*!
 * \enum IPOD_PLAYER_FUNC_ID
 * This is an enumeration of call ID.<br>
 */
 
 typedef enum
{
    /* Init Funcution ID. */
    IPOD_FUNC_INIT = 0x00,
    IPOD_FUNC_DEINIT,
    IPOD_FUNC_SELECT_AUDIO_OUT,
    IPOD_FUNC_TEST_READY,
    IPOD_FUNC_SET_IOS_APPS_INFO,
    IPOD_FUNC_START_AUTHENTICATION,
    /* Notify Function ID. */
    IPOD_FUNC_PLAYBACK_STATUS,
    IPOD_FUNC_CONNECTION_STATUS,
    IPOD_FUNC_TRACK_INFO,
    IPOD_FUNC_PLAYBACK_CHANGE,
    IPOD_FUNC_DB_ENTRIES,
    IPOD_FUNC_COVERART_DATA,
    IPOD_FUNC_OPEN_APP,
    IPOD_FUNC_CLOSE_APP,
    IPOD_FUNC_RECEIVE_FROM_APP,
    IPOD_FUNC_GPS_STATUS,
    IPOD_FUNC_GPS_DATA,
    IPOD_FUNC_GPS_CURRENT_POSITION,
    IPOD_FUNC_GPS_CURRENT_TIME,
    IPOD_FUNC_HMI_EVENT,
    IPOD_FUNC_LOCATION_INFO_STATUS,         /* support iap2 */
    IPOD_FUNC_VEHICLE_STATUS,               /* support iap2 */
    IPOD_FUNC_DEVICE_EVENT,
    /* Playback Function ID. */
    IPOD_FUNC_PLAY,
    IPOD_FUNC_PAUSE,
    IPOD_FUNC_STOP,
    IPOD_FUNC_NEXT_TRACK,
    IPOD_FUNC_PREV_TRACK,
    IPOD_FUNC_NEXTCHAPTER,
    IPOD_FUNC_PREVCHAPTER,
    IPOD_FUNC_FASTFORWARD,
    IPOD_FUNC_REWIND,
    IPOD_FUNC_GOTO_TRACK_POSITION,
    IPOD_FUNC_PLAYTRACK,
    IPOD_FUNC_RELEASE,
    /* Set Property Function ID. */
    IPOD_FUNC_SET_AUDIO_MODE,
    IPOD_FUNC_SET_MODE,
    IPOD_FUNC_SET_REPEAT,
    IPOD_FUNC_SET_SHUFFLE,
    IPOD_FUNC_SET_EQUALIZER,
    IPOD_FUNC_SET_VIDEO_DELAY,
    IPOD_FUNC_SET_VIDEO_SETTING,
    IPOD_FUNC_SET_DISPLAY_IMAGE,
    IPOD_FUNC_SET_PLAY_SPEED,
    IPOD_FUNC_SET_TRACK_INFO_NOTIFICATION,
    IPOD_FUNC_SET_DEVICE_EVENT_NOTIFICATION,
    /* Get Property Function ID.  */
    IPOD_FUNC_GET_VIDEO_SETTING,
    IPOD_FUNC_GET_COVERART_INFO,
    IPOD_FUNC_GET_COVERART,
    IPOD_FUNC_GET_PLAYBACK_STATUS,
    IPOD_FUNC_GET_TRACK_INFO,
    IPOD_FUNC_GET_CHAPTER_INFO,
    IPOD_FUNC_GET_MODE,
    IPOD_FUNC_GET_REPEAT,
    IPOD_FUNC_GET_SHUFFLE,
    IPOD_FUNC_GET_PLAY_SPEED,
    IPOD_FUNC_GET_TRACK_TOTAL_COUNT,
    IPOD_FUNC_GET_MEDIA_ITEM_INFO,
    IPOD_FUNC_GET_EQUALIZER,
    IPOD_FUNC_GET_EQUALIZER_NAME,
    IPOD_FUNC_GET_DEVICE_PROPERTY,
    IPOD_FUNC_GET_DEVICE_STATUS,
    /* Database Operation Function ID. */
    IPOD_FUNC_GET_DB_ENTRIES,
    IPOD_FUNC_GET_DB_COUNT,
    IPOD_FUNC_CANCEL,
    IPOD_FUNC_SELECT_DB_ENTRY,
    IPOD_FUNC_CLEAR_SELECTION,
    IPOD_FUNC_SELECT_AV,
    /* HMI Operation Function ID. */
    IPOD_FUNC_HMI_SET_SUPPORTED_FEATURE,
    IPOD_FUNC_HMI_GET_SUPPORTED_FEATURE,
    IPOD_FUNC_HMI_BUTTON_INPUT,
    IPOD_FUNC_HMI_ROTATION_INPUT,
    IPOD_FUNC_HMI_PLAYBACK_INPUT,
    IPOD_FUNC_HMI_SET_APPLICATION_STATUS,
    IPOD_FUNC_HMI_SET_EVENT_NOTIFICATION,
    IPOD_FUNC_HMI_GET_EVENT_CHANGE,
    IPOD_FUNC_HMI_GET_DEVICE_STATUS,
    /* Non Player Function ID. */
    IPOD_FUNC_OPEN_SONG_TAG_FILE,
    IPOD_FUNC_CLOSE_SONG_TAG_FILE,
    IPOD_FUNC_SONG_TAG,
    IPOD_FUNC_SEND_TO_APP,
    IPOD_FUNC_REQUEST_APP_START,
    IPOD_FUNC_SET_POWER_SUPPLY,
    IPOD_FUNC_SET_VOLUME,
    IPOD_FUNC_GET_VOLUME,
    IPOD_FUNC_CREATE_INTELLIGENT_PL,
    IPOD_FUNC_TRACK_SUPPORTS_INTELLIGENT_PL,
    IPOD_FUNC_REFRESH_INTELLIGENT_PL,
    IPOD_FUNC_GET_PL_PROPERTIES,
    IPOD_FUNC_SET_GPS_DATA,
    IPOD_FUNC_SET_GPS_CURRENT_SYSTEM_TIME,
    IPOD_FUNC_SET_DEVICE_DETECTION,
    IPOD_FUNC_SET_LOCATION_INFO,
    IPOD_FUNC_SET_VEHICLE_STATUS,
    /* Internal Function ID. */
    IPOD_FUNC_DEVINIT,
    IPOD_FUNC_DEVDETECT,
    IPOD_FUNC_DEVDEINIT,
    IPOD_FUNC_EF,
    /* Audio Streaming Function ID */
    IPOD_FUNC_PAI_START,
    IPOD_FUNC_PAI_STOP,
    IPOD_FUNC_PAI_SETCFG,
    IPOD_FUNC_PAI_SETSR,
    IPOD_FUNC_PAI_SETVOL,
    IPOD_FUNC_PAI_GETVOL,
    IPOD_FUNC_PAI_CLRCFG,
    IPOD_FUNC_PAI_RESULT,
    /* Internal function */
    IPOD_FUNC_INTERNAL_GET_STATUS,
    IPOD_FUNC_INTERNAL_NOTIFY_STATUS,
    IPOD_FUNC_INTERNAL_HMI_STATUS_SEND,
    IPOD_FUNC_INTERNAL_HMI_BUTTON_STATUS_SEND,
    IPOD_FUNC_INTERNAL_REMOTE_EVENT_NOTIFICATION,
    IPOD_FUNC_SHUTDOWN,             /* iPodPlayer shutdown */
    /* For iAP2 function */
    IPOD_FUNC_CHANGE_REPEAT,        /* support iap2 */
    IPOD_FUNC_CHANGE_SHUFFLE,       /* support iap2 */
    IPOD_FUNC_MAX
} IPOD_PLAYER_FUNC_ID;

typedef enum
{
    /* Init Function Result ID. */
    IPOD_FUNC_INIT_RESULT                           = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_INIT,
    IPOD_FUNC_DEINIT_RESULT                         = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_DEINIT,
    IPOD_FUNC_SELECT_AUDIO_OUT_RESULT               = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SELECT_AUDIO_OUT,
    IPOD_FUNC_TEST_READY_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_TEST_READY,
    IPOD_FUNC_SET_IOS_APPS_INFO_RESULT              = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_IOS_APPS_INFO,
    IPOD_FUNC_START_AUTHENTICATION_RESULT           = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_START_AUTHENTICATION,
    /* Notification ID. */
    IPOD_FUNC_NOTIFY_PLAYBACK_STATUS                = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PLAYBACK_STATUS,
    IPOD_FUNC_NOTIFY_CONNECTION_STATUS              = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_CONNECTION_STATUS,
    IPOD_FUNC_NOTIFY_TRACK_INFO                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_TRACK_INFO,
    IPOD_FUNC_NOTIFY_PLAYBACK_CHANGE                = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PLAYBACK_CHANGE,
    IPOD_FUNC_NOTIFY_DB_ENTRIES                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_DB_ENTRIES,
    IPOD_FUNC_NOTIFY_COVERART_DATA                  = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_COVERART_DATA,
    IPOD_FUNC_NOTIFY_OPEN_APP                       = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_OPEN_APP,
    IPOD_FUNC_NOTIFY_CLOSE_APP                      = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_CLOSE_APP,
    IPOD_FUNC_NOTIFY_RECEIVE_FROM_APP               = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_RECEIVE_FROM_APP,
    IPOD_FUNC_NOTIFY_GPS_STATUS                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GPS_STATUS,
    IPOD_FUNC_NOTIFY_GPS_DATA                       = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GPS_DATA,
    IPOD_FUNC_NOTIFY_GPS_CURRENT_POSITION           = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GPS_CURRENT_POSITION,
    IPOD_FUNC_NOTIFY_GPS_CURRENT_TIME               = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GPS_CURRENT_TIME,
    IPOD_FUNC_NOTIFY_HMI_EVENT                      = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_HMI_EVENT,
    IPOD_FUNC_NOTIFY_LOCATION_INFO_STATUS           = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_LOCATION_INFO_STATUS,  /* support iap2 */
    IPOD_FUNC_NOTIFY_VEHICLE_STATUS                 = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_VEHICLE_STATUS,        /* support iap2 */
    IPOD_FUNC_NOTIFY_DEVICE_EVENT                   = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_DEVICE_EVENT,
    /* Playback Function Result ID. */
    IPOD_FUNC_PLAY_RESULT                           = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PLAY,
    IPOD_FUNC_PAUSE_RESULT                          = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PAUSE,
    IPOD_FUNC_STOP_RESULT                           = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_STOP,
    IPOD_FUNC_NEXT_TRACK_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_NEXT_TRACK,
    IPOD_FUNC_PREV_TRACK_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PREV_TRACK,
    IPOD_FUNC_NEXTCHAPTER_RESULT                    = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_NEXTCHAPTER,
    IPOD_FUNC_PREVCHAPTER_RESULT                    = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PREVCHAPTER,
    IPOD_FUNC_FASTFORWARD_RESULT                    = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_FASTFORWARD,
    IPOD_FUNC_REWIND_RESULT                         = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_REWIND,
    IPOD_FUNC_GOTO_TRACK_POSITION_RESULT            = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GOTO_TRACK_POSITION,
    IPOD_FUNC_PLAYTRACK_RESULT                      = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PLAYTRACK,
    IPOD_FUNC_RELEASE_RESULT                        = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_RELEASE,               /* support only iAP2 */
    /* Set Property Function Result ID. */
    IPOD_FUNC_SET_AUDIO_MODE_RESULT                 = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_AUDIO_MODE,
    IPOD_FUNC_SET_MODE_RESULT                       = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_MODE,
    IPOD_FUNC_SET_REPEAT_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_REPEAT,
    IPOD_FUNC_SET_SHUFFLE_RESULT                    = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_SHUFFLE,
    IPOD_FUNC_SET_EQUALIZER_RESULT                  = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_EQUALIZER,
    IPOD_FUNC_SET_VIDEO_DELAY_RESULT                = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_VIDEO_DELAY,
    IPOD_FUNC_SET_VIDEO_SETTING_RESULT              = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_VIDEO_SETTING,
    IPOD_FUNC_SET_DISPLAY_IMAGE_RESULT              = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_DISPLAY_IMAGE,
    IPOD_FUNC_SET_PLAY_SPEED_RESULT                 = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_PLAY_SPEED,
    IPOD_FUNC_SET_TRACK_INFO_NOTIFICATION_RESULT    = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_TRACK_INFO_NOTIFICATION,
    IPOD_FUNC_SET_DEVICE_EVENT_NOTIFICATION_RESULT  = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_DEVICE_EVENT_NOTIFICATION,
    /* Get Porperty Function Result ID. */
    IPOD_FUNC_GET_VIDEO_SETTING_RESULT              = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_VIDEO_SETTING,
    IPOD_FUNC_GET_COVERART_INFO_RESULT              = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_COVERART_INFO,
    IPOD_FUNC_GET_COVERART_RESULT                   = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_COVERART,
    IPOD_FUNC_GET_PLAYBACK_STATUS_RESULT            = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_PLAYBACK_STATUS,
    IPOD_FUNC_GET_TRACK_INFO_RESULT                 = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_TRACK_INFO,
    IPOD_FUNC_GET_CHAPTER_INFO_RESULT               = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_CHAPTER_INFO,
    IPOD_FUNC_GET_MODE_RESULT                       = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_MODE,
    IPOD_FUNC_GET_REPEAT_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_REPEAT,
    IPOD_FUNC_GET_SHUFFLE_RESULT                    = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_SHUFFLE,
    IPOD_FUNC_GET_PLAY_SPEED_RESULT                 = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_PLAY_SPEED,
    IPOD_FUNC_GET_MEDIA_ITEM_INFO_RESULT            = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_MEDIA_ITEM_INFO,
    IPOD_FUNC_GET_TRACK_TOTAL_COUNT_RESULT          = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_TRACK_TOTAL_COUNT,
    IPOD_FUNC_GET_EQUALIZER_RESULT                  = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_EQUALIZER,
    IPOD_FUNC_GET_EQUALIZER_NAME_RESULT             = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_EQUALIZER_NAME,
    IPOD_FUNC_GET_DEVICE_PROPERTY_RESULT            = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_DEVICE_PROPERTY,
    IPOD_FUNC_GET_DEVICE_STATUS_RESULT              = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_DEVICE_STATUS,
    /* Database Operation Result ID. */
    IPOD_FUNC_GET_DB_ENTRIES_RESULT                 = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_DB_ENTRIES,
    IPOD_FUNC_GET_DB_COUNT_RESULT                   = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_DB_COUNT,
    IPOD_FUNC_CANCEL_RESULT                         = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_CANCEL,
    IPOD_FUNC_SELECT_DB_ENTRY_RESULT                = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SELECT_DB_ENTRY,
    IPOD_FUNC_CLEAR_SELECTION_RESULT                = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_CLEAR_SELECTION,
    IPOD_FUNC_SELECT_AV_RESULT                      = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SELECT_AV,
    /* HMI Operation Result ID. */
    IPOD_FUNC_HMI_SET_SUPPORTED_FEATURE_RESULT      = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_HMI_SET_SUPPORTED_FEATURE,
    IPOD_FUNC_HMI_GET_SUPPORTED_FEATURE_RESULT      = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_HMI_GET_SUPPORTED_FEATURE,
    IPOD_FUNC_HMI_BUTTON_INPUT_RESULT               = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_HMI_BUTTON_INPUT,
    IPOD_FUNC_HMI_ROTATION_INPUT_RESULT             = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_HMI_ROTATION_INPUT,
    IPOD_FUNC_HMI_PLAYBACK_INPUT_RESULT             = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_HMI_PLAYBACK_INPUT,
    IPOD_FUNC_HMI_SET_APPLICATION_STATUS_RESULT     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_HMI_SET_APPLICATION_STATUS,
    IPOD_FUNC_HMI_SET_EVENT_NOTIFICATION_RESULT     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_HMI_SET_EVENT_NOTIFICATION,
    IPOD_FUNC_HMI_GET_EVENT_CHANGE_RESULT           = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_HMI_GET_EVENT_CHANGE,
    IPOD_FUNC_HMI_GET_DEVICE_STATUS_RESULT          = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_HMI_GET_DEVICE_STATUS,
    /* Non Player Function Result ID. */
    IPOD_FUNC_OPEN_SONG_TAG_FILE_RESULT             = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_OPEN_SONG_TAG_FILE,
    IPOD_FUNC_CLOSE_SONG_TAG_FILE_RESULT            = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_CLOSE_SONG_TAG_FILE,
    IPOD_FUNC_SONG_TAG_RESULT                       = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SONG_TAG,
    IPOD_FUNC_SEND_TO_APP_RESULT                    = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SEND_TO_APP,
    IPOD_FUNC_REQUEST_APP_START_RESULT              = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_REQUEST_APP_START,
    IPOD_FUNC_SET_POWER_SUPPLY_RESULT               = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_POWER_SUPPLY,
    IPOD_FUNC_SET_VOLUME_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_VOLUME,
    IPOD_FUNC_GET_VOLUME_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_VOLUME,
    IPOD_FUNC_CREATE_INTELLIGENT_PL_RESULT          = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_CREATE_INTELLIGENT_PL,
    IPOD_FUNC_TRACK_SUPPORTS_INTELLIGENT_PL_RESULT  = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_TRACK_SUPPORTS_INTELLIGENT_PL,
    IPOD_FUNC_REFRESH_INTELLIGENT_PL_RESULT         = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_REFRESH_INTELLIGENT_PL,
    IPOD_FUNC_GET_PL_PROPERTIES_RESULT              = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_GET_PL_PROPERTIES,
    IPOD_FUNC_SET_GPS_DATA_RESULT                   = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_GPS_DATA,
    IPOD_FUNC_SET_GPS_CURRENT_SYSTEM_TIME_RESULT    = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_GPS_CURRENT_SYSTEM_TIME,
    IPOD_FUNC_SET_DEVICE_DETECTION_RESULT           = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_DEVICE_DETECTION,
    IPOD_FUNC_SET_LOCATION_INFO_RESULT              = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_LOCATION_INFO,     /* support iap2 */
    IPOD_FUNC_SET_VEHICLE_STATUS_RESULT             = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SET_VEHICLE_STATUS,    /* support iap2 */
    /* Internal Function Result ID. */
    IPOD_FUNC_DEVINIT_RESULT                        = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_DEVINIT,
    IPOD_FUNC_DEVDETECT_RESULT                      = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_DEVDETECT,
    IPOD_FUNC_DEVDEINIT_RESULT                      = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_DEVDEINIT,
    IPOD_FUNC_EF_RESULT                             = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_EF,
    /* Audio Streaming Function ID */
    IPOD_FUNC_PAI_START_RESULT                      = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PAI_START,
    IPOD_FUNC_PAI_STOP_RESULT                       = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PAI_STOP,
    IPOD_FUNC_PAI_SETCFG_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PAI_SETCFG,
    IPOD_FUNC_PAI_SETSR_RESULT                      = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PAI_SETSR,
    IPOD_FUNC_PAI_SETVOL_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PAI_SETVOL,
    IPOD_FUNC_PAI_GETVOL_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PAI_GETVOL,
    IPOD_FUNC_PAI_CLRCFG_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PAI_CLRCFG,
    IPOD_FUNC_PAI_RESULT_RESULT                     = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_PAI_RESULT,
    /* Internal function */
    IPOD_FUNC_INTERNAL_GET_STATUS_RESULT            = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_INTERNAL_GET_STATUS,
    IPOD_FUNC_INTERNAL_NOTIFY_STATUS_RESULT         = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_INTERNAL_NOTIFY_STATUS,
    IPOD_FUNC_INTERNAL_HMI_STATUS_SEND_RESULT       = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_INTERNAL_HMI_STATUS_SEND,
    IPOD_FUNC_INTERNAL_HMI_BUTTON_STATUS_SEND_RESULT= IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_INTERNAL_HMI_BUTTON_STATUS_SEND,
    IPOD_FUNC_INTERNAL_REMOTE_EVENT_NOTIFICATION_RESULT = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_INTERNAL_REMOTE_EVENT_NOTIFICATION,
    IPOD_FUNC_SHUTDOWN_RESULT                       = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_SHUTDOWN,             /* iPodPlayer shutdown result*/
    /* For iAP2 function */
    IPOD_FUNC_CHANGE_REPEAT_RESULT                  = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_CHANGE_REPEAT, 
    IPOD_FUNC_CHANGE_SHUFFLE_RESULT                 = IPOD_PLAYER_RESULT_ID_MASK | IPOD_FUNC_CHANGE_SHUFFLE,
    IPOD_FUNC_RESULT_MAX
} IPOD_PLAYER_FUNC_RESULT_ID;

/* ################################### iPod Player Message Header ########################################## */

/********* MESSAGE_API_STRUCT ************/

typedef struct
{
    IPOD_PLAYER_FUNC_ID funcId;
    U32 devID;
    U32 appID;
    U32 longData;
} IPOD_PLAYER_FUNC_HEADER;

/* iPodPlayerInitFunction */
typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 connectionMask;
    U8 uniqueName[IPOD_PLAYER_STRING_LEN_MAX];
}IPOD_PLAYER_PARAM_INIT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
}IPOD_PLAYER_PARAM_DEINIT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_AUDIO_SELECT mode;
}IPOD_PLAYER_PARAM_SELECT_AUDIO_OUT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_TEST_READY;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U8 appCount;
    /* todo */ 
    IPOD_PLAYER_IOSAPP_INFO info[10];
} IPOD_PLAYER_PARAM_SET_IOSAPPS_INFO;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_START_AUTHENTICATION;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_PLAYBACK_STATUS status;
} IPOD_PLAYER_PARAM_NOTIFY_PLAYBACK_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_CONNECTION_STATUS status;
} IPOD_PLAYER_PARAM_NOTIFY_CONNECTION_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 trackIndex;
    IPOD_PLAYER_TRACK_INFO info;
    U32 mask;
    U32 resultFlag;
    U32 sendMask;
} IPOD_PLAYER_PARAM_NOTIFY_TRACK_INFO;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
} IPOD_PLAYER_PARAM_NOTIFY_PLAYBACK_CHANGE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_DB_TYPE type;
    U32 count;
    IPOD_PLAYER_ENTRY_LIST list[IPOD_PLAYER_ENTRIES_ARRYA_MAX];
} IPOD_PLAYER_PARAM_NOTIFY_DB_ENTRIES;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 trackIndex;
    U32 time;
    IPOD_PLAYER_COVERART_HEADER coverartHeader;
    U32 size;
    U8 data[IPOD_PLAYER_DATA_SIZE_MAX];
} IPOD_PLAYER_PARAM_NOTIFY_COVERART_DATA;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 appID;
    U8 index;
    U16 session;
} IPOD_PLAYER_PARAM_NOTIFY_OPEN_APP;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 appID;
    U16 session;
} IPOD_PLAYER_PARAM_NOTIFY_CLOSE_APP;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 appID;
    U32 dataSize;
    U16 session;
} IPOD_PLAYER_PARAM_NOTIFY_RECEIVE_FROM_APP;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 bitmask;
} IPOD_PLAYER_PARAM_NOTIFY_GPS_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_GPS_TYPE type;
    U32 dataSize;
    U8 data[IPOD_PLAYER_DATA_SIZE_MAX];
} IPOD_PLAYER_PARAM_NOTIFY_GPS_DATA;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_GPS_TIME time;
    IPOD_PLAYER_GPS_ANGLE angle;
} IPOD_PLAYER_PARAM_NOTIFY_GPS_CURRENT_POSITION;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_GPS_TIME time;
} IPOD_PLAYER_PARAM_NOTIFY_GPS_CURRENT_TIME;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_HMI_STATUS_TYPE type;
    U32 status;
    IPOD_PLAYER_HMI_STATUS_DATE date;
} IPOD_PLAYER_PARAM_NOTIFY_HMI_EVENT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_DEVICE_EVENT_TYPE type;
    IPOD_PLAYER_DEVICE_EVENT_INFO event;
} IPOD_PLAYER_PARAM_NOTIFY_DEVICE_EVENT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_LOCATION_INFO_STATUS status;
    U32 locationMask;
} IPOD_PLAYER_PARAM_NOTIFY_LOCATION_INFO_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_VEHICLE_STATUS status;
} IPOD_PLAYER_PARAM_NOTIFY_VEHICLE_STATUS;

/* iPodPlayerPlayerOperationAPI */
typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    BOOL playCurSel;
} IPOD_PLAYER_PARAM_PLAY;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_PAUSE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_STOP;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_NEXT_TRACK;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_PREV_TRACK;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
}IPOD_PLAYER_PARAM_NEXT_CHAPTER;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
}IPOD_PLAYER_PARAM_PREV_CHAPTER;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
}IPOD_PLAYER_PARAM_FAST_FORWARD;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
}IPOD_PLAYER_PARAM_REWIND;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 times;
} IPOD_PLAYER_PARAM_GOTO_TRACK_POSITION;

typedef struct
{
    U16 current;
    U8  batteryCharge;
} IPOD_PLAYER_PARAM_POWER_SOURCE_UPDATE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_TRACK_TYPE type;
    U64 trackID;
} IPOD_PLAYER_PARAM_PLAY_TRACK;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_RELRASE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_AUDIO_SETTING setting;
} IPOD_PLAYER_PARAM_SET_AUDIO_MODE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_MODE mode;
} IPOD_PLAYER_PARAM_SET_MODE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_REPEAT_STATUS status;
} IPOD_PLAYER_PARAM_SET_REPEAT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_CHANGE_REPEAT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_SHUFFLE_STATUS status;
} IPOD_PLAYER_PARAM_SET_SHUFFLE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_CHANGE_SHUFFLE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 eq;
    U8 restore;
} IPOD_PLAYER_PARAM_SET_EQUALIZER;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 delayTime;
} IPOD_PLAYER_PARAM_SET_VIDEO_DELAY;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_VIDEO_SETTING setting;
    U32 restore;
} IPOD_PLAYER_PARAM_SET_VIDEO_SETTING;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 imageSize;
//    U8 image[IPOD_PLAYER_DATA_SIZE_MAX];
}IPOD_PLAYER_PARAM_SET_DISPLAY_IMAGE;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_PLAYING_SPEED speed;
}IPOD_PLAYER_PARAM_SET_PLAY_SPEED;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 trackInfoMask;
    U16 formatId;
} IPOD_PLAYER_PARAM_SET_TRACK_INFO_NOTIFICATION;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 deviceEventMask;
} IPOD_PLAYER_PARAM_SET_DEVICE_EVENT_NOTIFICATION;
typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 mask;
} IPOD_PLAYER_PARAM_GET_VIDEO_SETTING;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_TRACK_TYPE type;
    U64 trackIndex;
    U16 formatId;
} IPOD_PLAYER_PARAM_GET_COVERART_INFO;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_TRACK_TYPE type;
    U64 trackIndex;
    U16 formatId;
    U32 time;
} IPOD_PLAYER_PARAM_GET_COVERART;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_GET_PLAYBACK_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_TRACK_TYPE type;
    U64 startID;
    U32 count;
    U32 trackInfoMask;
    U32 actualMask;
    IPOD_PLAYER_TRACK_INFO info;
    U32 resultFlag;
    U64 startIndex;
    U32 mediaType;
} IPOD_PLAYER_PARAM_GET_TRACK_INFO;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_TRACK_TYPE type;
    U32 trackID;
    U32 startIndex;
    U32 count;
    U32 chapterInfoMask;
    U32 chapterIndex;
    IPOD_PLAYER_CHAPTER_INFO info;
} IPOD_PLAYER_PARAM_GET_CHAPTER_INFO;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_GET_MODE;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_GET_REPEAT_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_GET_SHUFFLE_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_GET_PLAY_SPEED;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_TRACK_TYPE type;
} IPOD_PLAYER_PARAM_GET_TRACK_TOTAL_COUNT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U64 trackID;
} IPOD_PLAYER_PARAM_GET_MEDIA_ITEM_INFO;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_GET_EQUALIZER;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 eq;
} IPOD_PLAYER_PARAM_GET_EQUALIZER_NAME;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 devicePropertyMask;
} IPOD_PLAYER_PARAM_GET_DEVICE_PROPERTY;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 deviceStatusMask;
} IPOD_PLAYER_PARAM_GET_DEVICE_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_DB_TYPE type;
    U32 start;
    S32 num;
    U32 totalNum;
    U32 curNum;
    U32 listNum;
    IPOD_PLAYER_ENTRY_LIST entry;
    IPOD_PLAYER_ENTRY_LIST *list;
} IPOD_PLAYER_PARAM_GET_DB_ENTRIES;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_DB_TYPE type;
} IPOD_PLAYER_PARAM_GET_DB_COUNT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_CANCEL_TYPE type;
} IPOD_PLAYER_PARAM_CANCEL;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_DB_TYPE type;
    S32 entry;
} IPOD_PLAYER_PARAM_SELECT_DB_ENTRY;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_DB_TYPE type;
} IPOD_PLAYER_PARAM_CLEAR_SELECTION;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U8 avType;
} IPOD_PLAYER_PARAM_SELECT_AV;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 bitmask;
} IPOD_PLAYER_PARAM_HMI_SET_SUPPORTED_FEATURE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_HMI_FEATURE_TYPE type;
    U32 reserved;
} IPOD_PLAYER_PARAM_HMI_GET_SUPPORTED_FEATURE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 event;
    IPOD_PLAYER_HMI_BUTTON_SOURCE source;
} IPOD_PLAYER_PARAM_HMI_BUTTON_INPUT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_HMI_ROTATION_INFO info;
    U16 move;
    U32 duration;
} IPOD_PLAYER_PARAM_HMI_ROTATION_INPUT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_HMI_PLAYBACK_EVENT event;
} IPOD_PLAYER_PARAM_HMI_PLAYBACK_INPUT;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_HMI_APP_STATUS status;
} IPOD_PLAYER_PARAM_HMI_SET_APPLICATION_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 bitmask;
} IPOD_PLAYER_PARAM_HMI_SET_EVENT_NOTIFICATION;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_PLAYER_PARAM_HMI_GET_EVENT_CHANGE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_HMI_STATUS_TYPE type;
} IPOD_PLAYER_PARAM_HMI_GET_DEVICE_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 tagOptionsMask;
    U32 optionLen;
    U8 optionData[IPOD_PLAYER_OPEN_TAG_OPTION_LEN_MAX];
} IPOD_PLAYER_PARAM_OPEN_SONG_TAG_FILE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 handle;
} IPOD_PLAYER_PARAM_CLOSE_SONG_TAG_FILE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 handle;
    IPOD_PLAYER_TAG_TYPE type;
    IPOD_PLAYER_TAG_INFO info;
} IPOD_PLAYER_PARAM_SONG_TAG;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 handle;
    U32 dataSize;
    U8 data[IPOD_PLAYER_DATA_SIZE_MAX];
} IPOD_PLAYER_PARAM_SEND_TO_APP;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    size_t size;
    U8 NMEAdata[IPOD_PLAYER_DATA_SIZE_MAX];
} IPOD_PLAYER_PARAM_LOCATION_INFO;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_SET_VEHICLE_STATUS status;
} IPOD_PLAYER_PARAM_SET_VEHICLE_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U8 appName[IPOD_PLAYER_STRING_LEN_MAX];
} IPOD_PLAYER_PARAM_REQUEST_APP_START;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_CURRENT powermA;
    U8                  chargeButtery;
} IPOD_PLAYER_PARAM_SET_POWER_SUPPLY;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U8 volume;
} IPOD_PLAYER_PARAM_SET_VOLUME;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
} IPOD_PLAYER_PARAM_GET_VOLUME;



typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_TRACK_TYPE type;
    U64 trackID;
} IPOD_PLAYER_PARAM_CREATE_INTELLIGENT_PL;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_TRACK_TYPE type;
    U64 trackID;
} IPOD_PLAYER_PARAM_TRACK_SUPPORTS_INTELLIGENT_PL;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 plIndex;
} IPOD_PLAYER_PARAM_REFRESH_INTELLIGENT_PL;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 plIndex;
    U32 mask;
} IPOD_PLAYER_PARAM_GET_PL_PROPERTIES;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_GPS_TYPE type;
    U32 dataSize;
    U8 data[IPOD_PLAYER_DATA_SIZE_MAX];
} IPOD_PLAYER_PARAM_SET_GPS_DATA;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_GPS_TIME time;
} IPOD_PLAYER_PARAM_SET_GPS_CURRENT_SYSTEM_TIME;

typedef struct
{
    U8 Name[IPOD_PLAYER_ACC_INFO_STRING_LEN_MAX + 1];
    IPOD_VERSION_NUMBER Hardware_version;
    IPOD_VERSION_NUMBER Software_version;
    U8 Manufacturer[IPOD_PLAYER_ACC_INFO_STRING_LEN_MAX + 1];
    U8 ModelNumber[IPOD_PLAYER_ACC_INFO_STRING_LEN_MAX + 1];
    U8 SerialNumber[IPOD_PLAYER_ACC_INFO_STRING_LEN_MAX + 1];

    U8 VendorId[IPOD_PLAYER_ACC_INFO_STRING_LEN_MAX + 1];
    U8 ProductId[IPOD_PLAYER_ACC_INFO_STRING_LEN_MAX + 1];
    U8 BCDDevice[IPOD_PLAYER_ACC_INFO_STRING_LEN_MAX + 1];

    /* supported ios in the car (supported carPlay) */
    U32 SupportedIOSInTheCar;
    /* number of supported ios app */
    U32 SupportediOSAppCount;

    /* identification information message code */
    S32 MsgSentByAccSize;
    U16 MsgSentByAcc[IPOD_PLAYER_IDEN_MSGCODE_MAX / 2];
    S32 MsgRecvFromDeviceSize;
    U16 MsgRecvFromDevice[IPOD_PLAYER_IDEN_MSGCODE_MAX / 2]; 
} IPOD_PLAYER_ACC_INFO_CONFIG;

typedef struct
{
    U8      iOSAppIdentifier;
    U8      iOSAppName[IPOD_PLAYER_STRING_LEN_MAX];
    BOOL    EANativeTransport;
    EAPMatchAction MatchAction;
} IPOD_PLAYER_ACC_IOS_INFO;

typedef struct
{
    BOOL displayName_valid;
    U8   displayName[IPOD_PLAYER_STRING_LEN_MAX];
} IPOD_PLAYER_VEHICLE_INFO_L;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_DEVICE_DETECTION_INFO info;
    IPOD_PLAYER_DEV_INFO devInfo;
    IPOD_PLAYER_BT_MAC_ADDR macAddr[IPOD_PLAYER_BT_MAC_COUNT_MAX];
    IPOD_PLAYER_ACC_INFO_CONFIG accInfo;
    IPOD_PLAYER_ACC_IOS_INFO iosInfo[IPODCORE_MAX_IOSAPPS_INFO_NUM];
    IPOD_PLAYER_VEHICLE_INFO_L vehicleInfo;
} IPOD_PLAYER_PARAM_SET_DEVICE_DETECTION;


#define IPOD_PLAYER_PAI_MAX_DEVICE_NAME 128
/* configuration parameter */
typedef struct
{
    unsigned int src_name_kind;  /* 0:use card name, 1:use alsa device name */
    char src_name[IPOD_PLAYER_PAI_MAX_DEVICE_NAME]; /* PulseAudio input device */
    char sink_name[IPOD_PLAYER_PAI_MAX_DEVICE_NAME]; /* PulseAudio output device */
} IPOD_PLAYER_PARAM_PAI_CFG_TABLE;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_PARAM_PAI_CFG_TABLE table;
} IPOD_PLAYER_PARAM_PAI_CFG;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    unsigned int rate;      /* initial sample rate */
} IPOD_PLAYER_PARAM_PAI_START;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    unsigned int sampleRate;
} IPOD_PLAYER_PARAM_PAI_SET_SAMPLE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U8 volume;
    S32 result;
} IPOD_PLAYER_PARAM_PAI_SET_VOLUME;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U8 volume;
    S32 result;
} IPOD_PLAYER_PARAM_PAI_GET_VOLUME;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    unsigned int cmdId;
    int result;
} IPOD_PLAYER_PARAM_PAI_RESULT;









/* NotiyCallbackType */
typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_CONNECTION_STATUS status;
} IPOD_CB_PARAM_NOTIFY_CONNECTION_STATUS;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 trackIndex;
    IPOD_PLAYER_TRACK_INFO info;
} IPOD_CB_PARAM_NOTIFY_TRACK_INFO;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 reserved;
} IPOD_CB_PARAM_NOTIFY_PLAYBACK_CHANGE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_DB_TYPE type;
    U32 count;
    /* todo */
    IPOD_PLAYER_ENTRY_LIST entryList[IPOD_PLAYER_ENTRIES_ARRYA_MAX];
} IPOD_CB_PARAM_NOTIFY_DB_ENTRIES;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 trackIndex;
    U32 time;
    IPOD_PLAYER_COVERART_HEADER *coverartHeader;
    U32 size;
    U8 data[IPOD_PLAYER_DATA_SIZE_MAX];
} IPOD_CB_PARAM_NOTIFY_COVERART_DATA;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    /* todo */
    U32 appHandle;
    U8 iOSID;
}IPOD_CB_PARAM_NOTIFY_OPEN_APP;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 appHandle;
}IPOD_CB_PARAM_NOTIFY_CLOSE_IOSAPP;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 appHandle;
    U32 dataSize;
    U8 data[IPOD_PLAYER_DATA_SIZE_MAX];
}IPOD_CB_PARAM_NOTIFY_RECEIVE_FROM_APP;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 bitmask;
} IPOD_CB_PARAM_NOTIFY_GPS_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_GPS_TYPE type;
    U32 dataSize;
    U8 data[IPOD_PLAYER_DATA_SIZE_MAX];
} IPOD_CB_PARAM_NOTIFY_GPS_DATA;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_GPS_TIME time;
    IPOD_PLAYER_GPS_ANGLE angle;
} IPOD_CB_PARAM_GPS_CURRENT_POSITION;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_GPS_TIME time;
} IPOD_CB_PARAM_CURRENT_TIME;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_HMI_STATUS_TYPE type;
    U32 status;
    IPOD_PLAYER_HMI_STATUS_DATE data[IPOD_PLAYER_DATA_SIZE_MAX];
} IPOD_CB_PARAM_NOTIFY_HMI_EVENT;










/* ResultCallbackType */
typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    BOOL playCurSel;
} IPOD_CB_PARAM_PLAY_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_PAUSE_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_STOP_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_NEXTTRACK_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_PREVTRACK_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_NEXT_CHAPTER_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_PREV_CHAPTER_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_FASTFORWARD_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_REWIND_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_GOTO_TRACK_POSITION_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_PLAY_TRACK_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_RELEASE_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_SHUFFLE_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_REPEAT_RESULT;

typedef struct                          /* support iAP2 */
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_CHANGE_SHUFFLE_RESULT;

typedef struct                          /* support iAP2 */
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_CHANGE_REPEAT_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_AUDIO_MODE_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_MODE_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_VIDEO_SETTING_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_EQUALIZER_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_PLAY_SPEED_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_TRACK_INFO_NOTIFICATION_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_DEVICE_EVENT_NOTIFICATION_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_VIDEO_DELAY_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_PLAYBACK_STATUS status;
} IPOD_CB_PARAM_GET_PLAYBACK_STATUS_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_TRACK_TYPE type;
    U64 trackID;
    IPOD_PLAYER_TRACK_INFO info;
    U64 startID;
    U32 count;
    U32 mask;
    U32 actualMask;
    U32 sendMask;
} IPOD_CB_PARAM_GET_TRACK_INFO_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U32 trackIndex;
    U32 chapterIndex;
    IPOD_PLAYER_CHAPTER_INFO info;
    IPOD_PLAYER_TRACK_TYPE type;
    U64 startID;
    U32 count;
    U32 mask;
    U32 chapCount;
    U32 *indexList;
    U32 *lengthList;
} IPOD_CB_PARAM_GET_CHAPTER_INFO_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_MODE mode;
} IPOD_CB_PARAM_GET_MODE_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_REPEAT_STATUS status;
} IPOD_CB_PARAM_GET_REPEAT_STATUS_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_SHUFFLE_STATUS status;
} IPOD_CB_PARAM_GET_SHUFFLE_STATUS_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_VIDEO_SETTING setting;
} IPOD_CB_PARAM_GET_VIDEO_SETTING_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U8 value;
} IPOD_CB_PARAM_GET_EQUALIZER_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U8 name[IPOD_PLAYER_STRING_LEN_MAX];
} IPOD_CB_PARAM_GET_EQUALIZER_NAME_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_PLAYING_SPEED speed;
} IPOD_CB_PARAM_GET_PLAY_SPEED_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_TRACK_TYPE type;
    U32 count;
} IPOD_CB_PARAM_GET_TRACK_TOTAL_COUNT_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U64 trackID;
    S32 mediaType;
} IPOD_CB_PARAM_GET_MEDIA_ITEM_INFO_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_GET_COVERART_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_DEVICE_PROPERTY property;
} IPOD_CB_PARAM_GET_DEVICE_PROPERTY_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_DEVICE_STATUS info;
} IPOD_CB_PARAM_GET_DEVICE_STATUS_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U32 timeCount;
    U32 time[IPOD_PLAYER_COVERART_TIME_ARRAY_MAX];
} IPOD_CB_PARAM_GET_COVERART_INFO_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SELECT_DB_ENTRY_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_CANCEL_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_CLEAR_SELECTION_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SELECT_AV_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_GET_DB_ENTRIES_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U32 num;
} IPOD_CB_PARAM_GET_DB_COUNT_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_GET_CANCEL_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_HMI_SET_SUPPORTED_FEATURE_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_HMI_FEATURE_TYPE type;
    U32 optionsBits;
} IPOD_CB_PARAM_HMI_GET_SUPPORTED_FEATURE_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_HMI_BUTTON_INPUT_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_HMI_PLAYBACK_INPUT_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_HMI_ROTATION_INPUT_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_HMI_SET_APPLICATION_STATUS_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_HMI_SET_EVENT_NOTIFICATION_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U32 bitmask;
} IPOD_CB_PARAM_HMI_GET_EVENT_CHANGE_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_HMI_STATUS_TYPE type;
    U32 status;
    IPOD_PLAYER_HMI_STATUS_DATE date;
} IPOD_CB_PARAM_HMI_GET_DEVICE_STATUS_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_GPS_DATA_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_GPS_CURRENT_SYSTEM_TIME_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_DEVICE_DETECTION_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_DISPLAY_IMAGE_RESULT;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_REQUEST_APP_START_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U32 handle;
} IPOD_CB_PARAM_SEND_TO_APP_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_LOCATION_INFO_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_VEHICLE_STATUS_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_VOLUME_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U8 volume;
} IPOD_CB_PARAM_GET_VOLUME_RESULT;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U32 handle;
} IPOD_CB_PARAM_OPEN_SONG_TAG_FILE_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_CLOSE_SONG_TAG_FILE_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SONG_TAG_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_SET_POWER_SUPPLY_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_CREATE_INTELLIGENT_PL_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U32 capble;
} IPOD_CB_PARAM_GET_PL_PROPERTIES_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_REFRESH_INTELLIGENT_PL_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CB_PARAM_TRACK_SUPPORTS_INTELLIGENT_PL_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U8 deviceName[IPOD_PLAYER_STRING_LEN_MAX];
    U8 audioInName[IPOD_PLAYER_STRING_LEN_MAX];
    U8 audioOutName[IPOD_PLAYER_STRING_LEN_MAX];
    U8 action;
} IPOD_PLAYER_PARAM_DEVDETECT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U8 deviceName[IPOD_PLAYER_STRING_LEN_MAX];
    U8 audioInName[IPOD_PLAYER_STRING_LEN_MAX];
    U8 audioOutName[IPOD_PLAYER_STRING_LEN_MAX];
    U8 action;
} IPOD_PLAYER_PARAM_DEVINIT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
} IPOD_PLAYER_PARAM_DEVDEINIT;



/* inner message */

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
} IPOD_PLAYER_PARAM_EF;
typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
}IPOD_PLAYER_PARAM_INIT_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
}IPOD_PLAYER_PARAM_DEINIT_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
}IPOD_PLAYER_PARAM_SELECT_AUDIO_OUT_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
}IPOD_PLAYER_PARAM_TEST_READY_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
}IPOD_PLAYER_PARAM_SET_IOSAPPS_INFO_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
}IPOD_PLAYER_PARAM_START_AUTHENTICATION_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CORE_INT_PARAM_GET_IPOD_INFO;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_CORE_INT_PARAM_FIRST_GET_IPOD_INFO;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U64 optionsBits[15];
} IPOD_CORE_INT_PARAM_FIRST_GET_IPOD_INFO_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U32 mask;
} IPOD_CORE_INT_PARAM_FIRST_SET_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
} IPOD_CORE_INT_PARAM_GET_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U8 status;
} IPOD_CORE_INT_PARAM_GET_STATUS_RESULT;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    U32 trackIndex;
} IPOD_CORE_INT_PARAM_GET_TRACK_INFO;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
    IPOD_PLAYER_TRACK_INFO info;
} IPOD_CORE_INT_PARAM_GET_TRACK_INFO_RESULT;


typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 sampleRate;
} IPOD_CORE_INT_PARAM_SET_SAMPLE;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U32 status;
    U64 param;
} IPOD_CORE_INT_PARAM_NOTIFY_STATUS;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    U8 repeatStatus; 
    U8 shuffleStatus;
} IPOD_CORE_INT_PARAM_REMOTE_EVENT_NOTIFICATION;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
} IPOD_PLAYER_PARAM_TEMP;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    S32 result;
} IPOD_PLAYER_PARAM_RESULT_TEMP;

typedef struct
{
    U32 trackIndex;
    U32 time;
    IPOD_PLAYER_COVERART_HEADER coverartHeader;
    U32 bufSize;
} IPOD_PLAYER_PARAM_INTERNAL_COVERART;

typedef struct
{
    IPOD_PLAYER_FUNC_HEADER header;
    IPOD_PLAYER_PARAM_INTERNAL_COVERART coverart;
} IPOD_PLAYER_PARAM_TEMP_LONG_DATA;

typedef union
{
    /* iPodPlayerInitFunction */
    IPOD_PLAYER_PARAM_INIT                              init;
    IPOD_PLAYER_PARAM_DEINIT                            deinit;
    IPOD_PLAYER_PARAM_SELECT_AUDIO_OUT                  selectAudioOut;
    IPOD_PLAYER_PARAM_TEST_READY                        testReady;
    IPOD_PLAYER_PARAM_SET_IOSAPPS_INFO                  setiOSAppsInfo;
    IPOD_PLAYER_PARAM_START_AUTHENTICATION              startAuthentication;
    
    IPOD_PLAYER_PARAM_NOTIFY_PLAYBACK_STATUS            notifyPlaybackStatus;
    IPOD_PLAYER_PARAM_NOTIFY_CONNECTION_STATUS          notifyConnectionStatus;
    IPOD_PLAYER_PARAM_NOTIFY_TRACK_INFO                 notifyTrackInfo;
    IPOD_PLAYER_PARAM_NOTIFY_PLAYBACK_CHANGE            notifyPlaybackChange;
    IPOD_PLAYER_PARAM_NOTIFY_DB_ENTRIES                 notifyDBEntries;
    IPOD_PLAYER_PARAM_NOTIFY_COVERART_DATA              notifyCoverartData;
    IPOD_PLAYER_PARAM_NOTIFY_OPEN_APP                   notifyOpenApp;
    IPOD_PLAYER_PARAM_NOTIFY_CLOSE_APP                  notifyCloseApp;
    IPOD_PLAYER_PARAM_NOTIFY_RECEIVE_FROM_APP           notifyReceiveFromApp;
    IPOD_PLAYER_PARAM_NOTIFY_GPS_STATUS                 notifyGPSStatus;
    IPOD_PLAYER_PARAM_NOTIFY_GPS_DATA                   notifyGPSData;
    IPOD_PLAYER_PARAM_NOTIFY_GPS_CURRENT_POSITION       notifyGPSCurrentPosition;
    IPOD_PLAYER_PARAM_NOTIFY_GPS_CURRENT_TIME           notifyGPSCurrentTime;
    IPOD_PLAYER_PARAM_NOTIFY_HMI_EVENT                  notifyHMIEvent;
    IPOD_PLAYER_PARAM_NOTIFY_DEVICE_EVENT               notifyDeviceEvent;
    IPOD_PLAYER_PARAM_NOTIFY_LOCATION_INFO_STATUS       notifyLocationInfoStatus;
    IPOD_PLAYER_PARAM_NOTIFY_VEHICLE_STATUS             notifyVehicleStatus;
    
    /* iPodPlayerPlayerOperationAPI */
    IPOD_PLAYER_PARAM_PLAY                              play;
    IPOD_PLAYER_PARAM_PAUSE                             pause;
    IPOD_PLAYER_PARAM_STOP                              stop;
    IPOD_PLAYER_PARAM_NEXT_TRACK                        trackUp;
    IPOD_PLAYER_PARAM_PREV_TRACK                        trackDown;
    IPOD_PLAYER_PARAM_NEXT_CHAPTER                      nextChapter;
    IPOD_PLAYER_PARAM_PREV_CHAPTER                      prevChapter;
    IPOD_PLAYER_PARAM_FAST_FORWARD                      fastForward;
    IPOD_PLAYER_PARAM_REWIND                            rewind;
    IPOD_PLAYER_PARAM_GOTO_TRACK_POSITION               gotoTrackPosition;
    IPOD_PLAYER_PARAM_SET_POWER_SUPPLY                  powerSourceUpdate;
    IPOD_PLAYER_PARAM_PLAY_TRACK                        playTrack;
    IPOD_PLAYER_PARAM_SET_AUDIO_MODE                    setAudioMode;
    IPOD_PLAYER_PARAM_SET_MODE                          setMode;
    IPOD_PLAYER_PARAM_SET_REPEAT                        setRepeat;
    IPOD_PLAYER_PARAM_SET_SHUFFLE                       setShuffle;
    IPOD_PLAYER_PARAM_CHANGE_REPEAT                     chengeRepeat;
    IPOD_PLAYER_PARAM_CHANGE_SHUFFLE                    chengeShuffle;



    IPOD_PLAYER_PARAM_SET_EQUALIZER                     setEqualizer;
    IPOD_PLAYER_PARAM_SET_VIDEO_DELAY                   setVideoDelay;
    IPOD_PLAYER_PARAM_SET_VIDEO_SETTING                 setVideoSetting;
    IPOD_PLAYER_PARAM_SET_DISPLAY_IMAGE                 setDisplayImage;
    IPOD_PLAYER_PARAM_SET_PLAY_SPEED                    setPlaySpeed;
    IPOD_PLAYER_PARAM_SET_TRACK_INFO_NOTIFICATION       setTrackInfoNotification;
    IPOD_PLAYER_PARAM_SET_DEVICE_EVENT_NOTIFICATION     setDeviceEventNotification;
    IPOD_PLAYER_PARAM_GET_VIDEO_SETTING                 getVideoSetting;
    IPOD_PLAYER_PARAM_GET_COVERART_INFO                 getCoverartInfo;
    IPOD_PLAYER_PARAM_GET_COVERART                      getCoverart;
    IPOD_PLAYER_PARAM_GET_PLAYBACK_STATUS               getPlaybackStatus;
    IPOD_PLAYER_PARAM_GET_TRACK_INFO                    getTrackInfo;
    IPOD_PLAYER_PARAM_GET_CHAPTER_INFO                  getChapterInfo;
    IPOD_PLAYER_PARAM_GET_MODE                          getMode;
    IPOD_PLAYER_PARAM_GET_REPEAT_STATUS                 getRepeat;
    IPOD_PLAYER_PARAM_GET_SHUFFLE_STATUS                getSHuffle;
    IPOD_PLAYER_PARAM_GET_PLAY_SPEED                    getPlaySpeed;
    IPOD_PLAYER_PARAM_GET_TRACK_TOTAL_COUNT             getTrackTotalCount;
    IPOD_PLAYER_PARAM_GET_MEDIA_ITEM_INFO               getMediaItemInfo;
    IPOD_PLAYER_PARAM_GET_EQUALIZER                     getEqualizer;
    IPOD_PLAYER_PARAM_GET_EQUALIZER_NAME                getEqualizerName;
    IPOD_PLAYER_PARAM_GET_DEVICE_PROPERTY               getDeviceProperty;
    IPOD_PLAYER_PARAM_GET_DEVICE_STATUS                 getDeviceStatus;
    IPOD_PLAYER_PARAM_GET_DB_ENTRIES                    getDBEntries;
    IPOD_PLAYER_PARAM_GET_DB_COUNT                      getDBCount;
    IPOD_PLAYER_PARAM_CANCEL                            cancel;
    IPOD_PLAYER_PARAM_SELECT_DB_ENTRY                   selectDBEntry;
    IPOD_PLAYER_PARAM_CLEAR_SELECTION                   clearSelection;
    IPOD_PLAYER_PARAM_SELECT_AV                         selectAV;
    IPOD_PLAYER_PARAM_HMI_SET_SUPPORTED_FEATURE         hmiSetSupportedFeature;
    IPOD_PLAYER_PARAM_HMI_GET_SUPPORTED_FEATURE         hmiGetSupportedFeature;
    IPOD_PLAYER_PARAM_HMI_BUTTON_INPUT                  hmiButtonInput;
    IPOD_PLAYER_PARAM_HMI_ROTATION_INPUT                hmiRotationInput;
    IPOD_PLAYER_PARAM_HMI_PLAYBACK_INPUT                hmiPlaybackInput;
    IPOD_PLAYER_PARAM_HMI_SET_APPLICATION_STATUS        hmiSetApplicationStatus;
    IPOD_PLAYER_PARAM_HMI_SET_EVENT_NOTIFICATION        hmiSetEventNotification;
    IPOD_PLAYER_PARAM_HMI_GET_EVENT_CHANGE              hmiGetEventChange;
    IPOD_PLAYER_PARAM_HMI_GET_DEVICE_STATUS             hmiGetDeviceStatus;
    IPOD_PLAYER_PARAM_OPEN_SONG_TAG_FILE                openSongTagFile;
    IPOD_PLAYER_PARAM_CLOSE_SONG_TAG_FILE               closeSongTagFile;
    IPOD_PLAYER_PARAM_SONG_TAG                          songTag;
    IPOD_PLAYER_PARAM_SEND_TO_APP                       sendToApp;
    IPOD_PLAYER_PARAM_REQUEST_APP_START                 requestAppStart;
    IPOD_PLAYER_PARAM_SET_POWER_SUPPLY                  setPowerSupply;
    IPOD_PLAYER_PARAM_SET_VOLUME                        setVolume;
    IPOD_PLAYER_PARAM_SET_VOLUME                        getVolume;
    IPOD_PLAYER_PARAM_CREATE_INTELLIGENT_PL             createIntelligentPL;
    IPOD_PLAYER_PARAM_TRACK_SUPPORTS_INTELLIGENT_PL     trackSupportIntelligentPL;
    IPOD_PLAYER_PARAM_REFRESH_INTELLIGENT_PL            refreshIntelligentPL;
    IPOD_PLAYER_PARAM_GET_PL_PROPERTIES                 getPLProperties;
    IPOD_PLAYER_PARAM_SET_GPS_DATA                      setGPSData;
    IPOD_PLAYER_PARAM_SET_GPS_CURRENT_SYSTEM_TIME       setGPSCurrentSystemTime;
    IPOD_PLAYER_PARAM_LOCATION_INFO                     locationInfo;
    IPOD_PLAYER_PARAM_SET_VEHICLE_STATUS                vehicleStatus;

    IPOD_PLAYER_PARAM_SET_DEVICE_DETECTION              setDeviceDetection;

    IPOD_PLAYER_PARAM_PAI_CFG                           paiCfg;
    IPOD_PLAYER_PARAM_PAI_START                         paiStart;
    IPOD_PLAYER_PARAM_PAI_SET_SAMPLE                    paiSetSample;
    IPOD_PLAYER_PARAM_PAI_SET_VOLUME                    paiSetVolume;
    IPOD_PLAYER_PARAM_PAI_GET_VOLUME                    paiGetVolume;


    /* ResultCallbackType */
    IPOD_CB_PARAM_PLAY_RESULT                           playResult;
    IPOD_CB_PARAM_PAUSE_RESULT                          pauseResult;
    IPOD_CB_PARAM_STOP_RESULT                           stopResult;
    IPOD_CB_PARAM_NEXTTRACK_RESULT                      nextTrackResult;
    IPOD_CB_PARAM_PREVTRACK_RESULT                      prevTrackResult;
    IPOD_CB_PARAM_NEXT_CHAPTER_RESULT                   nextChapterResult;
    IPOD_CB_PARAM_PREV_CHAPTER_RESULT                   prevChapterResult;
    IPOD_CB_PARAM_FASTFORWARD_RESULT                    fastforwardResult;
    IPOD_CB_PARAM_REWIND_RESULT                         rewindResult;
    IPOD_CB_PARAM_GOTO_TRACK_POSITION_RESULT            gotoTrackPositionResult;
    IPOD_CB_PARAM_PLAY_TRACK_RESULT                     playTrackResult;
    IPOD_CB_PARAM_RELEASE_RESULT                        releaseResult;              /* support only iAP2 */
    IPOD_CB_PARAM_SET_AUDIO_MODE_RESULT                 setAudioModeResult;
    IPOD_CB_PARAM_SET_MODE_RESULT                       setModeResult;
    IPOD_CB_PARAM_SET_REPEAT_RESULT                     setRepeatResult;
    IPOD_CB_PARAM_SET_SHUFFLE_RESULT                    setShuffleResult;
    IPOD_CB_PARAM_CHANGE_REPEAT_RESULT                  changeRepeatResult;         /* support iAP2 */
    IPOD_CB_PARAM_CHANGE_SHUFFLE_RESULT                 changeShuffleResult;        /* support iAP2 */
    IPOD_CB_PARAM_SET_EQUALIZER_RESULT                  setEqualizerResult;
    IPOD_CB_PARAM_SET_VIDEO_DELAY_RESULT                setVideoDelayResult;
    IPOD_CB_PARAM_SET_VIDEO_SETTING_RESULT              setVideoSettingResult;
    IPOD_CB_PARAM_SET_DISPLAY_IMAGE_RESULT              setDisplayImageResult;
    IPOD_CB_PARAM_SET_PLAY_SPEED_RESULT                 setPlaySpeedResult;
    IPOD_CB_PARAM_SET_TRACK_INFO_NOTIFICATION_RESULT    setTrackInfoNotificationResult;
    IPOD_CB_PARAM_SET_DEVICE_EVENT_NOTIFICATION_RESULT  setDeviceEventNotificationResult;
    IPOD_CB_PARAM_GET_VIDEO_SETTING_RESULT              getVideoSettingResult;
    IPOD_CB_PARAM_GET_COVERART_INFO_RESULT              getCoverartInfoResult;
    IPOD_CB_PARAM_GET_COVERART_RESULT                   getCoverartResult;
    IPOD_CB_PARAM_GET_PLAYBACK_STATUS_RESULT            getPlaybackStatusResult;
    IPOD_CB_PARAM_GET_TRACK_INFO_RESULT                 getTrackInfoResult;
    IPOD_CB_PARAM_GET_CHAPTER_INFO_RESULT               getChapterInfoResult;
    IPOD_CB_PARAM_GET_MODE_RESULT                       getModeResult;
    IPOD_CB_PARAM_GET_REPEAT_STATUS_RESULT              getRepeatResult;
    IPOD_CB_PARAM_GET_SHUFFLE_STATUS_RESULT             getShuffleResult;
    IPOD_CB_PARAM_GET_PLAY_SPEED_RESULT                 getPlaySpeedResult;
    IPOD_CB_PARAM_GET_TRACK_TOTAL_COUNT_RESULT          getTrackTotalCountResult;
    IPOD_CB_PARAM_GET_MEDIA_ITEM_INFO_RESULT            getMediaItemMediaItemInfoResult;
    IPOD_CB_PARAM_GET_EQUALIZER_RESULT                  getEqualizerResult;
    IPOD_CB_PARAM_GET_EQUALIZER_NAME_RESULT             getEqualizerNameResult;
    IPOD_CB_PARAM_GET_DEVICE_PROPERTY_RESULT            getDevicePropertyResult;
    IPOD_CB_PARAM_GET_DEVICE_STATUS_RESULT              getDeviceStatusResult;
    IPOD_CB_PARAM_GET_DB_ENTRIES_RESULT                 getDBEntriesResult;
    IPOD_CB_PARAM_GET_DB_COUNT_RESULT                   getDBCountResult;
    IPOD_CB_PARAM_SELECT_DB_ENTRY_RESULT                selectDBEntryResult;
    IPOD_CB_PARAM_CANCEL_RESULT                         cancelResult;
    IPOD_CB_PARAM_CLEAR_SELECTION_RESULT                clearSelectionResult;
    IPOD_CB_PARAM_SELECT_AV_RESULT                      selectAVResult;
    IPOD_CB_PARAM_HMI_SET_SUPPORTED_FEATURE_RESULT      hmiSetSupportedFeatureResult;
    IPOD_CB_PARAM_HMI_GET_SUPPORTED_FEATURE_RESULT      hmiGetSupportedFeatureResult;
    IPOD_CB_PARAM_HMI_BUTTON_INPUT_RESULT               hmiButtonInputResult;
    IPOD_CB_PARAM_HMI_ROTATION_INPUT_RESULT             hmiRotationInputResult;
    IPOD_CB_PARAM_HMI_PLAYBACK_INPUT_RESULT             hmiPlaybackInputResult;
    IPOD_CB_PARAM_HMI_SET_APPLICATION_STATUS_RESULT     hmiSetApplicationStatusResult;
    IPOD_CB_PARAM_HMI_SET_EVENT_NOTIFICATION_RESULT     hmiSetEventNotificationResult;
    IPOD_CB_PARAM_HMI_GET_EVENT_CHANGE_RESULT           hmiGetEventChangeResult;
    IPOD_CB_PARAM_HMI_GET_DEVICE_STATUS_RESULT          hmiGetDeviceStatusResult;
    IPOD_CB_PARAM_SET_GPS_CURRENT_SYSTEM_TIME_RESULT    setGPSCurrentSystemTimeResult;
    
    IPOD_CB_PARAM_SET_DEVICE_DETECTION_RESULT           setDeviceDetectionResult;
    
    
    
    IPOD_CB_PARAM_REQUEST_APP_START_RESULT              requestAppStartResult;
    IPOD_CB_PARAM_SEND_TO_APP_RESULT                    sendToAppResult;
    IPOD_CB_PARAM_SET_VOLUME_RESULT                     setVolumeResult;
    IPOD_CB_PARAM_GET_VOLUME_RESULT                     getVolumeResult;
    IPOD_CB_PARAM_LOCATION_INFO_RESULT                  locationInfoResult;
    IPOD_CB_PARAM_SET_VEHICLE_STATUS_RESULT             vehicleStatusResult;
    
    IPOD_CB_PARAM_OPEN_SONG_TAG_FILE_RESULT             openSongTagFileResult;
    IPOD_CB_PARAM_CLOSE_SONG_TAG_FILE_RESULT            closeSongTagFileResult;
    IPOD_CB_PARAM_SONG_TAG_RESULT                       songTagResult;
    IPOD_CB_PARAM_SET_POWER_SUPPLY_RESULT               setPowerSupplyResult;
    IPOD_CB_PARAM_CREATE_INTELLIGENT_PL_RESULT          createIntelligentPLResult;
    IPOD_CB_PARAM_GET_PL_PROPERTIES_RESULT              getPLPropertiesResult;
    IPOD_CB_PARAM_REFRESH_INTELLIGENT_PL_RESULT         refreshIntelligentPLResult;
    IPOD_CB_PARAM_TRACK_SUPPORTS_INTELLIGENT_PL_RESULT  trackSupportIntelligentPLResult;
    IPOD_PLAYER_PARAM_PAI_RESULT                        paiResult;
    
    /* Internal */
    IPOD_PLAYER_PARAM_DEVDETECT                         devDetect;
    IPOD_PLAYER_PARAM_DEVINIT                           devInit;
    IPOD_PLAYER_PARAM_DEVDEINIT                         devDeinit;
    IPOD_PLAYER_PARAM_EF                                endForward;
    IPOD_PLAYER_PARAM_INIT_RESULT                       initResult;
    IPOD_PLAYER_PARAM_DEINIT_RESULT                     deinitResult;
    IPOD_PLAYER_PARAM_SELECT_AUDIO_OUT_RESULT           selectAudioOutResult;
    IPOD_PLAYER_PARAM_TEST_READY_RESULT                 testReadyResult;
    IPOD_PLAYER_PARAM_SET_IOSAPPS_INFO_RESULT           setiOSAppsInfoResult;
    IPOD_PLAYER_PARAM_START_AUTHENTICATION_RESULT       startAuthenticationResult;
    IPOD_CORE_INT_PARAM_FIRST_GET_IPOD_INFO             firstGetiPodInfo;
    IPOD_CORE_INT_PARAM_FIRST_GET_IPOD_INFO_RESULT      firstInfoResult;
    IPOD_CORE_INT_PARAM_FIRST_SET_STATUS                firstSetStatus;
    IPOD_CORE_INT_PARAM_GET_STATUS                      intGetStatus;
    IPOD_CORE_INT_PARAM_GET_STATUS_RESULT               intGetStatusResult;
    IPOD_CORE_INT_PARAM_GET_TRACK_INFO                  intGetTrackInfo;
    IPOD_CORE_INT_PARAM_GET_TRACK_INFO_RESULT           intGetTrackInfoResult;
    IPOD_CORE_INT_PARAM_SET_SAMPLE                      setSample;
    IPOD_CORE_INT_PARAM_NOTIFY_STATUS                   intNotifyStatus;
    IPOD_CORE_INT_PARAM_REMOTE_EVENT_NOTIFICATION       intRemoteEvent;
    IPOD_PLAYER_PARAM_TEMP                              paramTemp;
    IPOD_PLAYER_PARAM_RESULT_TEMP                       paramResultTemp;
    IPOD_PLAYER_PARAM_TEMP_LONG_DATA                    longDataTemp;

}IPOD_PLAYER_MESSAGE_DATA_CONTENTS;

typedef struct
{
    IPOD_PLAYER_ENTRY_LIST *entryList;
    U32 setCnt;
}IPOD_PLAYER_ENTRY_LIST_INT;

/* ####################################### iPod init Operation ######################################### */
/* socket name for iPod Plrayer Core */
#define IPOD_PLAYER_CORE_SOCKET_NAME "CoreSock"
#define IPOD_PLAYER_CORE_SOCKET_LONG_NAME "CoreSock_long"

/* ##################################################################################################### */

#endif /* IPOD_PLAYER_DEF_H */

